/*----------------------------------------------------------------------
MODULE vco.sv
A voltage-controlled oscillator (VCO) model in XMODEL
----------------------------------------------------------------------*/

`include "xmodel.h"

module vco #(
    parameter real in_min = 0.0,        // input voltage at f=freq_min
    parameter real in_max = 1.0,        // input voltage at f=freq_max
    parameter real freq_min = 1.5e9,    // minimum frequency
    parameter real freq_max = 2.5e9     // maximum frequency
)(
    output xbit out,                    // output clock
    input xreal in	                    // input voltage
);

    xreal freq; 

    parameter real Kvco = (freq_max-freq_min)/(in_max-in_min);
    parameter real foffset = freq_min-Kvco*in_min;
    poly_func   #(.data('{foffset, Kvco}))
                v2f (.in(in), .out(freq));
    freq_to_clk #(.num_phase(1))
                freq2clk(.out(out), .in(freq));

endmodule
