/*----------------------------------------------------------------------
MODULE pfd.sv
A linear phase/freqeuncy detector in XMODEL.
----------------------------------------------------------------------*/

`include "xmodel.h"

module pfd #(
    parameter real delay_rst = 30e-12   // reset propagation delay
)(
    output xbit up,	                    // up signal
    output xbit dn,	                    // down signal
    input xbit clk_ref,                 // reference clock
    input xbit clk_fb                   // feedback clock
);

    xbit rst;

    dff_rst_async_xbit #(.init_value(1'b0)) dff_up(.q(up), .d(`one_xbit), .clk(clk_ref), .rst(rst));
    dff_rst_async_xbit #(.init_value(1'b0)) dff_dn(.q(dn), .d(`one_xbit), .clk(clk_fb), .rst(rst));
    and2_xbit #(.delay(delay_rst)) and_xbit(.out(rst), .in_a(up), .in_b(dn));

endmodule
