/*----------------------------------------------------------------------
MODULE vco.sv
A voltage-controlled oscillator (VCO) model in Real-Number Verilog 
----------------------------------------------------------------------*/

module vco #(
    parameter real in_min = 0.0,        // input voltage at f=freq_min
    parameter real in_max = 1.0,        // input voltage at f=freq_max
    parameter real freq_min = 1.5e9,    // minimum frequency
    parameter real freq_max = 2.5e9     // maximum frequency
)(
    output reg out,                     // output clock
    input real in                       // input voltage
);

    real freq = freq_min;
    real next = 0.0;
    initial out = 0;

    always begin
        #(next) out = ~out;
        freq = (freq_max-freq_min)/(in_max-in_min) * in + freq_min;
        next = (0.5/freq)/`TIME_SCALE;
    end

endmodule 
