/*----------------------------------------------------------------------
MODULE pfd.sv
A linear phase/freqeuncy detector in Real-Number Verilog.
----------------------------------------------------------------------*/

module pfd #(
    parameter real delay_rst = 30e-12   // reset propagation delay
)(
    output reg up,                      // up signal
    output reg dn,                      // down signal
    input  clk_ref,                     // reference clock
    input  clk_fb                       // feedback clock
);

    wire rst;

    initial begin
        up = 0;
        dn = 0;
    end

    always @(posedge clk_ref or posedge rst) begin
        if (rst) up <= 0;
        else up <= 1;
    end
        
    always @(posedge clk_fb or posedge rst) begin
        if (rst) dn <= 0;
        else dn <= 1;
    end

    assign #(delay_rst/`TIME_SCALE) rst = up & dn;

endmodule
