/*----------------------------------------------------------------------
MODULE cp_pll.sv
A charge-pump phase-locked loop (PLL) model in XMODEL
----------------------------------------------------------------------*/

`include "xmodel.h"

module cp_pll #(
    parameter real init_vctrl = 0.5     // initial control voltage
)(
    output xbit out,                    // output clock
    input xbit  in                      // input clock
);

    xbit up, dn;
    xreal vctrl;

    // phase/frequency detector
    pfd         pfd(.up(up), .dn(dn), .clk_ref(in), .clk_fb(out));

    // charge-pump loop filter
    lf          #(.init_value(init_vctrl))
                lf(.up(up), .dn(dn), .out(vctrl));

    // voltage-controlled oscillator
    vco         vco(.in(vctrl), .out(out));
    
endmodule
