/*----------------------------------------------------------------------
MODULE lf.sv
A charge-pump loop filter in XMODEL
----------------------------------------------------------------------*/

`include "xmodel.h"

module lf #(
    parameter real init_value = 0.5,    // initial value
    parameter real I_up = 21e-6,        // up current
    parameter real I_dn = 20e-6,        // down current
    parameter real Rs = 20e3,           // series resistance of loop filter
    parameter real Cs = 500e-15,        // series capacitance of loop filter
    parameter real Cp = 50e-15          // shunt capacitance of loop filter
)(
    output xreal out,                   // output voltage
    input xbit up,                      // up input from pfd
    input xbit dn                       // dn input from pfd
);

    xreal iup, idn;
    xreal n;

    transition  #(.value0(0.0), .value1(I_up))
                cp_up (.out(iup), .in(up));
    transition  #(.value0(0.0), .value1(I_dn))
                cp_dn (.out(idn), .in(dn));

    isource     #(.mode("in")) I0 (.in(iup), .pos(`ground), .neg(out));
    isource     #(.mode("in")) I1 (.in(idn), .pos(out), .neg(`ground));
    resistor    #(.R(Rs)) R0 (.pos(out), .neg(n));
    capacitor   #(.C(Cs), .ic(init_value)) C0 (.pos(n), .neg(`ground));
    capacitor   #(.C(Cp), .ic(init_value)) C1 (.pos(out), .neg(`ground));

endmodule
