/*----------------------------------------------------------------------
TESTBENCH tb_locking.sv
A testbench to observe the locking behavior of a charge-pump PLL.
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_locking();	

    parameter real ref_freq = 2.0e9;    // reference clock frequency 

    xbit clk_ref;                       // reference clock
    xbit clk_out;                       // output clock

    // reference clock generator
    clk_gen #(.freq(ref_freq))  clk_gen(clk_ref);

    // charge-pump phase-locked loop
    cp_pll  #(.init_vctrl(0.0))
            cp_pll(.in(clk_ref), .out(clk_out));

    // waveform dumping
    initial begin
        $xmodel_dumpfile("xmodel.jez");
        $xmodel_dumpvars(clk_ref, clk_out, cp_pll.vctrl);
    end

endmodule
