/*----------------------------------------------------------------------
TESTBENCH tb_locking.sv
A testbench to observe the locking behavior of a charge-pump PLL.
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_locking();	

    parameter real ref_freq = 2.0e9;    // reference clock frequency 

    wire clk_ref;                       // reference clock
    wire clk_out;                       // output clock
    xbit clk_ref_xbit;

    // reference clock generator
    clk_gen #(.freq(ref_freq))  clk_gen(.out(clk_ref_xbit));
    xbit_to_bit conn(.in(clk_ref_xbit), .out(clk_ref));

    // charge-pump phase-locked loop
    cp_pll  #(.init_vctrl(0.0))
            cp_pll(.in(clk_ref), .out(clk_out));

    // waveform dumping
    initial begin
        $xmodel_dumpfile("rnv.fsdb");
        $xmodel_dumpvars(clk_ref, clk_out, cp_pll.vctrl);
    end

endmodule
